** PURPOSE: To match information about parents to their natural children 
** CREATED BY: ALITA NANDI
** CREATED ON: 18-04-2018

clear all
cap log close

global m "Folder Path where UKHLS datafiles are stored"

log using Linking_Parents_Information.log, replace

foreach w in a b c d e f g {
	// Extracting parental information needed to be linked
	use pidp `w'_birthy `w'_?npid using "$m/`w'_indall", clear
	save temp, replace
	
	// Creating files with mothers' information (w_m.dta) and fathers information (w_f.dta)
	foreach v in m f {
		use temp, clear
		keep pidp `w'_`v'npid
		keep if `w'_`v'npid>0 & `w'_`v'npid<.
		rename pidp kpidp
		rename `w'_`v'npid pidp
		merge m:1 pidp using temp, keepus(`w'_birthy)
		drop if _m==2
		drop _m
		rename `w'_birthy `w'_`v'birthy
		keep pidp kpidp `w'_`v'birthy
		rename pidp `v'npid
		rename kpidp pidp
		save `w'_`v', replace
	}
	// Combining mothers and fathers information into one file w_parents.dta
	use `w'_m, clear
	merge 1:1 pidp using `w'_f
	drop _m
	save `w'_parents, replace
	
	describe
	summarize
	
	// erase unwanted files
	erase `w'_m.dta
	erase `w'_f.dta
}
erase temp.dta
log close
exit

