** PURPOSE: To match information about parents to their natural children 
** CREATED BY: ALITA NANDI
** CREATED ON: 18-04-2018

clear all
cap log close

global m "Folder Path where UKHLS datafiles are stored"

log using Linking_Child_Information.log, replace

foreach w in a b c d e f g {
	use pidp `w'_birthy `w'_mnpid using "$m/`w'_indall", clear
	save temp, replace
	use temp, clear
	keep pidp `w'_mnpid
	keep if `w'_mnpid>0 & `w'_mnpid<.
	rename pidp kpidp
	rename `w'_mnpid pidp
	merge m:1 pidp using temp, keepus(`w'_birthy)
	drop if _m==2
	drop _m
	rename `w'_birthy `w'_mbirthy
	keep pidp kpidp `w'_mbirthy
	rename pidp `w'_mnpid
	rename kpidp pidp
	merge 1:1 pidp using temp
	drop if _m==2
	drop _m
	rename `w'_birthy `w'_kbirthy
	lab var `w'_mbirthy "birth year of mother"
	lab var `w'_mbirthy "birth year of child"
	rename pidp kpidp
	lab var kpidp "child pidp"
	rename `w'_mnpid pidp
	lab var pidp "mother pidp"
	duplicates report pidp
	duplicates report kpidp
	su
	save `w'_mother_child_info, replace
}

erase temp.dta
log close
exit

