// do-file to check number of interviews in waves 1-5 for respondents who are fostered children
foreach x in a b c d e  {
	use "V:/main/eudb/stata/`x'_egoalt.dta", clear
	keep if `x'_relationship_dv==6
	keep pidp 
	bys pidp: keep if _n==1
	save cur_fostrch_`x', replace
	}
foreach x in a b c d {
	append using cur_fostrch_`x'
	}
bys pidp: keep if _n==1 // only need to keep info once.
save pidp_curfch, replace

// merge in those who had a_lvag14==7
use pidp a_lvag14 using "V:/main/eudb/stata/a_indresp.dta", clear
keep if a_lvag14==7 
keep pidp
// combine with pidp for resp. ever reported to be foster child
append using pidp_curfch.dta
bys pidp: keep if _n==1
// complete list of resp. who reported to have lived in care or where
// foster child during waves 1-5
save all_fostrch, replace

foreach x in a b c d e  {
	use "V:/main/eudb/stata/`x'_indall.dta", clear
	keep pidp `x'_dvage `x'_ivfio
	rename `x'_* *
	gen wave=strpos("abcde","`x'")
	lab var wave "wave"
	save indall_`x', replace
	}
foreach x in a b c d {
	append using indall_`x'
	}
merge m:1 pidp using all_fostrch.dta
fre _merge
// How many sample members have ever reported to be a foster child or to
// have lived in 
gen fostered=(_merge==3)
lab def fostered 0"not fostered" 1"fostered", replace
lab val fostered fostered
lab var fostered "Foster child or in care aged 14"
fre fostered
drop _merge
xtset pidp wave

// ennumeration pattern across waves 1-5
xtdes if fostered==1, pat(27)
// ennumeration pattern across waves 1-5: with full adult interview	
xtdes if ivfio==1 & fostered==1, pat(27)	
// ennumeration pattern across waves 1-5: with full youth interview	
xtdes if ivfio==21 & fostered==1, pat(27)		
save indall_w1_w5_with_fostered, replace

foreach x in a b c d e {
	erase cur_fostrch_`x'.dta
	erase indall_`x'.dta
}
erase all_fostrch.dta
erase pidp_curfch.dta
