clear all
set more off
cap log close

cd "Your working directory"
glo m "where data is downloaded"

log using "yourlogfile.log", replace

foreach w in b {
	qui use "$m/ukhls/`w'_indresp", clear
	rename `w'_* *
	keep pidp sppid hiqual_dv sex_dv
	drop if sppid==-8
	tempfile `w'
	save ``w'', replace
	use ``w'', clear
	drop sppid
	rename pidp sppid
	rename hiqual_dv sp_hiqual_dv
	rename sex_dv sp_sex_dv
	merge 1:1 sppid using ``w''
	
	recode hiqual_dv    (1/2=1 "high") (3/9=2 "low"), gen(edu) label(edu)
	recode sp_hiqual_dv (.=0 "no partner") (1/2=1 "high") (3/9=2 "low"), gen(sp_edu) label(sp_edu)
	drop sppid 
	drop if pidp==.
	
	ta edu sp_edu, m
	
	recode edu -9=.
	recode sp_edu -9=.
	
	ta edu sp_edu, m
	
	generat edu_gen=1 if sex_dv==1 & edu==1
	replace edu_gen=2 if sex_dv==1 & edu==2
	replace edu_gen=3 if sex_dv==2 & edu==1
	replace edu_gen=4 if sex_dv==2 & edu==2
	lab def edu_gen 1 "Men High Edu" 2 "Men Low Edu" 3 "Women High Edu" 4 "Women Low Edu"
	lab val edu_gen edu_gen
	fre edu_gen
	
	ta edu_gen sp_edu, cell nofreq
	
}


log close
exit
