// Creates ch1bm_dv ch1by_dv anychild_dv - first child information
clear all
set more off

// WRITE FILEPATH WHERE YOU HAVE DOWNLOADED THE SN6931, SPECIFICALLY THE FOLDER WHICH CONTAINS THE SUBFOLDERS UKHLS & BHPS
global inpath ""
// WRITE FILEPATH WHERE YOU HAVE DOWNLOADED THE SN8380, SPECIFICALLY THE FOLDER WHICH CONTAINS THE SUBFOLDERS BHPS_W1 BHPS_W2...BHPS_W18 BHPS_WX"
global inpath2 ""
// WRITE FILEPATH WHERE YOU WOULD LIKE TO SAVE THE OUTPUT FILE, ch1b.dta
global outpath ""
// Replace 12 with latest wave number
global wn1 12




************* DO NOT MAKE CHANGES AFTER THIS POINT ********************

forval i=1/$wn1 {
	global m`i' $inpath
}
forval i = 1/$wn1 { 
		local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1) 
		local x `x' `w'
}
global wavelist `x'
di "$wavelist"


// UKHLS variables

/*====================================================================
                        1:
====================================================================*/
forval i = 1/1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	// proxy
	use pidp `w'_ch1bm `w'_ch1by4 `w'_ivfio using "${m`i'}/`w'_indresp", clear
	su if `w'_ivfio==1
	su if `w'_ivfio==2
	keep if `w'_ivfio==2
	keep if `w'_ch1bm~=-8
	g pr_child=1
	generat pr_ch1by=`w'_ch1by4
	replace pr_ch1by=. if `w'_ch1by4<0
	generat pr_ch1bm=`w'_ch1bm 
	replace pr_ch1bm=6       if `w'_ch1by4>0 & `w'_ch1bm<0
	replace pr_ch1bm=. if `w'_ch1by4<0
	keep pidp pr_ch1bm pr_ch1by pr_child
	save ch1b1, replace

	// non-resident children
	use `w'_hidp `w'_pno `w'_childno `w'_lchlv `w'_lchdoby `w'_lchdobm using "${m`i'}/`w'_natchild", clear
	su `w'_lchdoby `w'_lchdobm if `w'_lchlv==1
	su `w'_lchdoby `w'_lchdobm if `w'_lchlv==2
	// 2022-01-21 add value 3 (child died) insted of just 2 (non resident child)
	keep if inlist(`w'_lchlv,2,3)
	drop `w'_lchlv
	su
	replace `w'_lchdobm=6  if `w'_lchdoby>0 & `w'_lchdobm<0
	replace `w'_lchdobm=-9 if `w'_lchdoby<0
	replace `w'_lchdoby=-9 if `w'_lchdoby<0
	g nr_child=1
	mvdecode `w'_lchdobm `w'_lchdoby, mv(-9)
	bys `w'_hidp `w'_pno (`w'_lchdoby `w'_lchdobm): g m=`w'_lchdobm if _n==1
	bys `w'_hidp `w'_pno (`w'_lchdoby `w'_lchdobm): g y=`w'_lchdoby if _n==1
	bys `w'_hidp `w'_pno: egen nr_ch1bm=sum(m)
	bys `w'_hidp `w'_pno: egen nr_ch1by=sum(y)
	bys `w'_hidp `w'_pno: keep if _n==1
	keep `w'_hidp `w'_pno nr_ch1bm nr_ch1by nr_child
	merge 1:1 `w'_hidp `w'_pno using "${m`i'}/`w'_indall", keepus(pidp)
	drop if _merge==2
	drop _merge `w'_hidp `w'_pno
	fre nr_child
	save ch1b2, replace

	// resident children
	foreach v in m f {
		// change 2022-01-21 - replace indresp with indall
		use pidp `w'_birthy `w'_birthm `w'_`v'npid using "${m`i'}/`w'_indall", clear
		rename pidp kpidp
		rename `w'_birthy kbirthy
		rename `w'_birthm kbirthm
		rename `w'_`v'npid pidp
		keep if pidp>0
		replace kbirthm=6 if kbirthm<0 & kbirthy>0 & kbirthy<.
		replace kbirthm=-9 if kbirthy<0
		replace kbirthy=-9 if kbirthy<0
		g rs_child=1
		mvdecode kbirthm kbirthy, mv(-9)
		bys pidp (kbirthy kbirthm): g m=kbirthm if _n==1
		bys pidp (kbirthy kbirthm): g y=kbirthy if _n==1
		bys pidp: egen rs_ch1bm=sum(m)
		bys pidp: egen rs_ch1by=sum(y)
		bys pidp: keep if _n==1
		keep pidp rs_ch1bm rs_ch1by rs_child
		save `v', replace
	}
	use m, clear
	merge 1:1 pidp using f

	use m, clear
	append using f
	save ch1b3, replace

	use ch1b1, clear
	merge 1:1 pidp using ch1b2
	drop _merge
	merge 1:1 pidp using ch1b3
	drop _merge
	foreach v in rs nr pr {
		g `v'=`v'_ch1by*12+`v'_ch1bm
	}
	// 2022-01-15 Added this line "recode rs 0=."
	recode rs 0=.
	egen x=rmin(rs nr pr)
	g ch1by=.
	g ch1bm=.
	foreach v in rs nr pr {
		replace ch1by=`v'_ch1by if x==`v'
		replace ch1bm=`v'_ch1bm if x==`v'
	}
	g y=1 if rs_child==1|nr_child==1|pr_child==1

	replace ch1by=-9 if ch1by==. & y==1
	replace ch1bm=-9 if ch1bm==. & y==1

	su pidp ch1bm ch1by y

	rename y `w'_child
	rename ch1bm `w'_ch1bm
	rename ch1by `w'_ch1by4

	keep pidp `w'_ch1bm `w'_ch1by4 `w'_child
	
	save `w'_ch1b, replace
}

forval i = 2/$wn1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)

	// new entrants
	use pidp `w'_ch1bm `w'_ch1by4 using "${m`i'}/`w'_indresp", clear
	keep if `w'_ch1by4~=-8
	rename `w'_ch1bm pr_ch1bm
	rename `w'_ch1by4 pr_ch1by
	g pr_child=1
	save ch1b1, replace
	
	// returning respondents
	use "${m`i'}/`w'_newborn", clear
	duplicates report pidp
	duplicates report pidp `w'_newchno `w'_lchbm `w'_lchby4 
	keep pidp `w'_newchno `w'_lchbm `w'_lchby4 `w'_lchlv
	// 2022-01-21 add value 3 (child died) insted of just 2 (non resident child)
	keep if inlist(`w'_lchlv,2,3)
	drop `w'_lchlv
	su
	replace `w'_lchbm=6  if `w'_lchby4>0 & `w'_lchbm<0
	replace `w'_lchbm=-9 if `w'_lchby4<0
	replace `w'_lchby4=-9 if `w'_lchby4<0
	g nr_child=1
	mvdecode `w'_lchbm `w'_lchby4, mv(-9)
	bys pidp (`w'_lchby4 `w'_lchbm): g m=`w'_lchbm if _n==1
	bys pidp (`w'_lchby4 `w'_lchbm): g y=`w'_lchby4 if _n==1
	bys pidp: egen nr_ch1bm=sum(m)
	bys pidp: egen nr_ch1by=sum(y)
	bys pidp: keep if _n==1
	keep pidp nr_ch1bm nr_ch1by nr_child
	save ch1b2, replace
	
	
	foreach v in m f {
		// change 2022-01-21 - replace indresp with indall
		use pidp `w'_birthy `w'_birthm `w'_`v'npid using "${m`i'}/`w'_indall", clear
		rename pidp kpidp
		rename `w'_birthy kbirthy
		rename `w'_birthm kbirthm
		rename `w'_`v'npid pidp
		keep if pidp>0
		replace kbirthm=6 if kbirthm<0 & kbirthy>0 & kbirthy<.
		replace kbirthm=-9 if kbirthy<0
		replace kbirthy=-9 if kbirthy<0
		g rs_child=1
		mvdecode kbirthm kbirthy, mv(-9)
		bys pidp (kbirthy kbirthm): g m=kbirthm if _n==1
		bys pidp (kbirthy kbirthm): g y=kbirthy if _n==1
		bys pidp: egen rs_ch1bm=sum(m)
		bys pidp: egen rs_ch1by=sum(y)
		bys pidp: keep if _n==1
		keep pidp rs_ch1bm rs_ch1by rs_child
		save `v', replace
	}
	use m, clear
	merge 1:1 pidp using f
	use m, clear
	append using f
	save ch1b3, replace
	
	use ch1b1, clear
	merge 1:1 pidp using ch1b2
	drop _merge
	merge 1:1 pidp using ch1b3
	drop _merge
	foreach v in rs nr pr {
		g `v'=`v'_ch1by*12+`v'_ch1bm
	}
	// 2022-01-15 Added this line "recode rs 0=."
	recode rs 0=.
	egen x=rmin(rs nr pr)
	g ch1by=.
	g ch1bm=.
	foreach v in rs nr pr {
		replace ch1by=`v'_ch1by if x==`v'
		replace ch1bm=`v'_ch1bm if x==`v'
	}
	g y=1 if rs_child==1|nr_child==1|pr_child==1

	replace ch1by=-9 if ch1by==. & y==1
	replace ch1bm=-9 if ch1bm==. & y==1

	su pidp ch1bm ch1by y

	rename y `w'_child
	rename ch1bm `w'_ch1bm
	rename ch1by `w'_ch1by4

	keep pidp `w'_ch1bm `w'_ch1by4 `w'_child

	save `w'_ch1b, replace
	
	
}
forval i = 6/6 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	// proxy+new entrants
	use pidp `w'_ch1bm `w'_ch1by4 `w'_ivfio using "${m`i'}/`w'_indresp", clear
	keep if `w'_ch1bm~=-8
	g pr_child=1
	generat pr_ch1by=`w'_ch1by4
	replace pr_ch1by=. if `w'_ch1by4<0
	generat pr_ch1bm=`w'_ch1bm 
	replace pr_ch1bm=6       if `w'_ch1by4>0 & `w'_ch1bm<0
	replace pr_ch1bm=. if `w'_ch1by4<0
	keep pidp pr_ch1bm pr_ch1by pr_child
	save ch1b1, replace

	// non-resident children - IEMB
	use pidp `w'_hidp `w'_pno `w'_childno `w'_lchlv `w'_lchdoby `w'_lchdobm using "${m`i'}/`w'_natchild", clear
	su `w'_lchdoby `w'_lchdobm if `w'_lchlv==1
	su `w'_lchdoby `w'_lchdobm if `w'_lchlv==2
	// 2022-01-21 add value 3 (child died) insted of just 2 (non resident child)
	keep if inlist(`w'_lchlv,2,3)
	drop `w'_lchlv
	su
	replace `w'_lchdobm=6  if `w'_lchdoby>0 & `w'_lchdobm<0
	replace `w'_lchdobm=-9 if `w'_lchdoby<0
	replace `w'_lchdoby=-9 if `w'_lchdoby<0
	g nr_child=1
	mvdecode `w'_lchdobm `w'_lchdoby, mv(-9)
	bys `w'_hidp `w'_pno (`w'_lchdoby `w'_lchdobm): g m=`w'_lchdobm if _n==1
	bys `w'_hidp `w'_pno (`w'_lchdoby `w'_lchdobm): g y=`w'_lchdoby if _n==1
	bys `w'_hidp `w'_pno: egen nr_ch1bm=sum(m)
	bys `w'_hidp `w'_pno: egen nr_ch1by=sum(y)
	bys `w'_hidp `w'_pno: keep if _n==1
	keep `w'_hidp `w'_pno nr_ch1bm nr_ch1by nr_child
	merge 1:1 `w'_hidp `w'_pno using "${m`i'}/`w'_indall", keepus(pidp)
	drop if _merge==2
	drop _merge `w'_hidp `w'_pno
	fre nr_child
	save ch1b2, replace
    // non-resident children - non-IEMB, continuing members
	use "${m`i'}/`w'_newborn", clear
	duplicates report pidp
	duplicates report pidp `w'_newchno `w'_lchbm `w'_lchby4 
	keep pidp `w'_newchno `w'_lchbm `w'_lchby4 `w'_lchlv
	keep if `w'_lchlv==2
	drop `w'_lchlv
	su
	replace `w'_lchbm=6  if `w'_lchby4>0 & `w'_lchbm<0
	replace `w'_lchbm=-9 if `w'_lchby4<0
	replace `w'_lchby4=-9 if `w'_lchby4<0
	g nr_child=1
	mvdecode `w'_lchbm `w'_lchby4, mv(-9)
	bys pidp (`w'_lchby4 `w'_lchbm): g m=`w'_lchbm if _n==1
	bys pidp (`w'_lchby4 `w'_lchbm): g y=`w'_lchby4 if _n==1
	bys pidp: egen nr_ch1bm=sum(m)
	bys pidp: egen nr_ch1by=sum(y)
	bys pidp: keep if _n==1
	keep pidp nr_ch1bm nr_ch1by nr_child
	append using ch1b2
	save ch1b2, replace

	// resident children
	foreach v in m f {
		// change 2022-01-21 - replace indresp with indall
		use pidp `w'_birthy `w'_birthm `w'_`v'npid using "${m`i'}/`w'_indall", clear
		rename pidp kpidp
		rename `w'_birthy kbirthy
		rename `w'_birthm kbirthm
		rename `w'_`v'npid pidp
		keep if pidp>0
		replace kbirthm=6 if kbirthm<0 & kbirthy>0 & kbirthy<.
		replace kbirthm=-9 if kbirthy<0
		replace kbirthy=-9 if kbirthy<0
		g rs_child=1
		mvdecode kbirthm kbirthy, mv(-9)
		bys pidp (kbirthy kbirthm): g m=kbirthm if _n==1
		bys pidp (kbirthy kbirthm): g y=kbirthy if _n==1
		bys pidp: egen rs_ch1bm=sum(m)
		bys pidp: egen rs_ch1by=sum(y)
		bys pidp: keep if _n==1
		keep pidp rs_ch1bm rs_ch1by rs_child
		save `v', replace
	}
	use m, clear
	merge 1:1 pidp using f

	use m, clear
	append using f
	save ch1b3, replace

	use ch1b1, clear
	merge 1:1 pidp using ch1b2
	drop _merge
	merge 1:1 pidp using ch1b3
	drop _merge
	foreach v in rs nr pr {
		g `v'=`v'_ch1by*12+`v'_ch1bm
	}
	// 2022-01-15 Added this line "recode rs 0=."
	recode rs 0=.
	egen x=rmin(rs nr pr)
	g ch1by=.
	g ch1bm=.
	foreach v in rs nr pr {
		replace ch1by=`v'_ch1by if x==`v'
		replace ch1bm=`v'_ch1bm if x==`v'
	}
	g y=1 if rs_child==1|nr_child==1|pr_child==1

	replace ch1by=-9 if ch1by==. & y==1
	replace ch1bm=-9 if ch1bm==. & y==1

	su pidp ch1bm ch1by y

	rename y `w'_child
	rename ch1bm `w'_ch1bm
	rename ch1by `w'_ch1by4
	
	keep pidp `w'_ch1bm `w'_ch1by4 `w'_child

	save `w'_ch1b, replace
}

use a_ch1b, clear
forval i = 2/$wn1 {
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	merge 1:1 pidp using `w'_ch1b
	drop _merge
}
duplicates report pidp


generat ch1bm=.
generat ch1by=.
generat child=.
foreach w of global wavelist {
	replace ch1bm=`w'_ch1bm if `w'_ch1bm<. & `w'_ch1bm>0 & ch1bm==.
	replace ch1by=`w'_ch1by4 if `w'_ch1by4<. & `w'_ch1by4>0 & ch1by==.
	replace child=1         if `w'_child==1
}
fre child
fre ch1bm if child==1
replace ch1bm=0 if ch1bm==. & child==1
replace ch1by=0 if ch1by==. & child==1

replace ch1bm=6 if ch1bm==0 & ch1by>0 & ch1by<.
replace ch1bm=0 if ch1bm!=0 & ch1by==0

*br pidp *ch1* if child==1
su pidp *ch1* if child==1
drop *_ch1bm *_ch1by4 *_child

foreach var in ch1bm ch1by child {
	rename `var' `var'_dv
}
lab var ch1bm_dv "First child birth month"
lab var ch1by_dv "First child birth year"
lab def ch1by_dv -9 "missing or wild" 0 "has child, date missing", modify
lab val ch1by_dv ch1by_dv
lab def ch1bm_dv -9 "missing or wild" 0 "has child, date missing" ///
                  1 "january" ///
				  2 "february" ///
				  3 "march" ///
				  4 "april" ///
				  5 "may" ///
				  6 "june" ///
				  7 "july" ///
				  8 "august" ///
				  9 "september" ///
				  10 "october" ///
				  11 "november" ///
				  12 "december", modify
lab val ch1bm_dv ch1bm_dv

lab var child_dv "Ever had a child"

fre ch1bm_dv ch1by_dv child_dv
save "$outpath/ch1b_ukhls", replace

forval i = 1/1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	use pidp `w'_lprnt `w'_nchild_dv using "${m`i'}/`w'_indresp", clear
	fre `w'_lprnt `w'_nchild_dv
	save `w', replace
}
forval i = 2/$wn1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	use pidp `w'_lprnt `w'_nchild_dv `w'_father using "${m`i'}/`w'_indresp", clear
	fre `w'_lprnt `w'_nchild_dv
	save `w', replace
}
use a, clear
forval i = 2/$wn1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	merge 1:1 pidp using `w', nogen 
}
g child=.
foreach w in a  {
	replace child=1 if `w'_lprnt==1
	replace child=1 if `w'_nchild_dv>=1 & `w'_nchild_dv<.
	replace child=0 if `w'_lprnt==2 & child==.
	replace child=0 if `w'_nchild_dv==0 & child==.
}
forval i = 2/$wn1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	replace child=1 if `w'_lprnt==1
	replace child=1 if `w'_nchild_dv>=1 & `w'_nchild_dv<.
	replace child=0 if `w'_lprnt==2 & child==.
	replace child=0 if `w'_nchild_dv==0 & child==.
	replace child=0 if `w'_father==2 & child==.
	replace child=0 if `w'_father==3 & child==.
}
fre child

keep pidp child
merge 1:1 pidp using "$outpath/ch1b_ukhls"

ta child_dv child, m

replace child_dv=0 if child==0 & child_dv==.
replace child_dv=1 if child==1 & child_dv==.

replace ch1by_dv=0 if ch1by_dv==. & child_dv==1
replace ch1bm_dv=0 if ch1bm_dv==. & child_dv==1

keep pidp ch1bm_dv ch1by_dv child_dv
save "$outpath/ch1b_ukhls", replace


// BHPS variables
use pidp ch1bm ch1by lprnt using "$inpath2/xwavedat", clear
foreach v in ch1bm ch1by lprnt {
	recode `v' (-8 -7 -2 -1 = -9)
	ren `v' `v'_bh
}

// first child
fre lprnt_bh
replace ch1bm_bh=-9 if ch1bm_bh>-9  & ch1bm_bh<. & ch1by_bh<0
replace ch1bm_bh=6  if ch1bm_bh<0   & ch1by>-9 & ch1by_bh<.

cou if ch1bm_bh>0 & ch1bm_bh<. & ch1by_bh<0
cou if ch1by_bh>0 & ch1by_bh<. & ch1bm_bh<0
cou if ch1bm_bh==. & ch1by_bh<.
cou if ch1by_bh==. & ch1bm_bh<.

fre ch1bm_bh ch1by_bh if lprnt_bh==1
fre ch1bm_bh ch1by_bh if lprnt_bh==2
fre ch1bm_bh ch1by_bh if lprnt_bh<0

replace ch1bm_bh=0 if lprnt_bh==1 & ch1bm_bh<0
replace ch1by_bh=0 if lprnt_bh==1 & ch1by_bh<0
fre ch1bm_bh ch1by_bh if lprnt_bh==1

g z=.
foreach v in a b c d e f g h i j k l m n o p q r {
	merge 1:1 pid using "$inpath2/`v'indresp.dta", keepus(`v'nchild) nogen
	replace z=1 if `v'nchild>0 & `v'nchild<.
}
ta z lprnt_bh, m
save temp, replace

use temp, clear
keep if lprnt_bh~=1 & z==1
fre lprnt_bh ch1by_bh ch1bm_bh 
replace ch1by_bh=0
replace ch1bm_bh=0
replace lprnt_bh=1  
fre lprnt_bh ch1by_bh ch1bm_bh
keep pidp lprnt_bh ch1by_bh ch1bm_bh
merge 1:1 pidp using temp
assert _m!=1
drop _m *child z
save "$outpath\ch1b_bhps", replace


// Combine BHPS & UKHLS variables
use pidp using "$inpath/xwavedat", clear
save temp, replace
use "$outpath\ch1b_bhps", clear
merge 1:1 pidp using "$outpath\ch1b_ukhls", nogen
merge 1:1 pidp using temp
drop _m

// UPDATING CH1BM,Y WITH BHPS INFO
recode ch1bm_dv (. = -9)
recode ch1by_dv (. = -9)
recode child_dv (. = -9) (0 = 2)

recode ch1by_bh (. = -9)
recode ch1bm_bh (. = -9)
recode lprnt_bh (. = -9)

assert (ch1bm_dv>=0 & ch1bm_dv<. & ch1by_dv>=0 & ch1by_dv<. & child_dv==1)|(ch1bm_dv==-9 & ch1by_dv==-9 & inlist(child_dv,2,-9))
assert (ch1bm_bh>=0 & ch1bm_bh<. & ch1by_bh>=0 & ch1by_bh<. & lprnt_bh==1)|(ch1bm_bh==-9 & ch1by_bh==-9 & inlist(lprnt_bh,2,-9))
fre ch1by_dv ch1bm_dv if child_dv==1
fre ch1by_bh ch1bm_bh if lprnt_bh==1

replace ch1by_dv=ch1by_bh if inlist(child_dv,2,-9) & inlist(lprnt_bh,1)
replace ch1bm_dv=ch1bm_bh if inlist(child_dv,2,-9) & inlist(lprnt_bh,1)
replace child_dv=1        if inlist(child_dv,2,-9) & inlist(lprnt_bh,1)

replace child_dv=2        if inlist(child_dv,-9) & inlist(lprnt_bh,2)

assert (lprnt_bh<0 & inlist(child_dv,-9,1,2))|(lprnt_bh==2 & inlist(child_dv,1,2))|(lprnt_bh==1 & inlist(child_dv,1))
assert (ch1bm_dv>=0 & ch1bm_dv<. & ch1by_dv>=0 & ch1by_dv<. & child_dv==1)|(ch1bm_dv==-9 & ch1by_dv==-9 & inlist(child_dv,2,-9))
fre ch1by_dv ch1bm_dv if child_dv==1

generat x=1 if child_dv==1 &   ch1by_dv==0              &  ch1bm_dv==0               & ((ch1by_bh>0 & ch1by_bh<.) & (ch1bm_bh>0 & ch1bm_bh<.))
replace x=2 if child_dv==1 & ((ch1by_dv>0 & ch1by_dv<.) & (ch1bm_dv>0 & ch1bm_dv<.)) & ((ch1by_bh>0 & ch1by_bh<.) & (ch1bm_bh>0 & ch1bm_bh<.)) & ch1by_bh<ch1by_dv
replace x=3 if child_dv==1 & ((ch1by_dv>0 & ch1by_dv<.) & (ch1bm_dv>0 & ch1bm_dv<.)) & ((ch1by_bh>0 & ch1by_bh<.) & (ch1bm_bh>0 & ch1bm_bh<.)) & ch1by_bh==ch1by_dv & ch1bm_bh<ch1bm_dv
fre x

replace ch1by_dv=ch1by_bh if inlist(x,1,2,3)
replace ch1bm_dv=ch1bm_bh if inlist(x,1,2,3)
drop x

assert (ch1bm_dv>=0 & ch1bm_dv<. & ch1by_dv>=0 & ch1by_dv<. & child_dv==1)|(ch1bm_dv==-9 & ch1by_dv==-9 & inlist(child_dv,2,-9))

fre ch1bm_dv ch1by_dv if child_dv==1
fre ch1bm_dv ch1by_dv if child_dv==2

drop ch1bm_bh ch1by_bh

rename child_dv anychild_dv
cap lab def anychild_dv 1 "Yes" 2 "No"
lab val anychild_dv anychild_dv
lab var anychild_dv "Ever had a (biological) child"

cap drop lprnt_bh //no longer generated?

lab var ch1bm_dv "First (biological) child birth month"
lab var ch1by_dv "First (biological) child birth year"
lab def ch1by_dv -9 "missing" 0 "has child, date missing", modify
lab val ch1by_dv ch1by_dv
lab def ch1bm_dv ///
	-9 "missing" ///
	0 "has child, date missing" ///
	1 "january" ///
	2 "february" ///
	3 "march" ///
	4 "april" ///
	5 "may" ///
	6 "june" ///
	7 "july" ///
	8 "august" ///
	9 "september" ///
	10 "october" ///
	11 "november" ///
	12 "december", modify
lab val ch1bm_dv ch1bm_dv

drop if inlist(pidp,1927139,2434482,2441322,2788044)

save "$outpath\ch1b", replace


// clean up - remove files not needed anymore
forval i = 1/$wn1 { 
	local w = substr("abcdefghijklmnopqrstuvwxyz",`i',1)
	erase `w'_ch1b.dta
	erase `w'.dta
}
erase ch1b1.dta
erase ch1b2.dta
erase ch1b3.dta
erase m.dta
erase "$outpath/ch1b_ukhls.dta"
erase "$outpath/ch1b_bhps.dta"

exit