global pathdata2 "path to your data"  
cd "path to your working folder"

foreach w in a b d f h j l {
	use pidp *jbpen using "$pathdata2/`w'_indresp", clear
	gen wave=strpos("abcdefghijklm","`w'")
	renpfix `w'_
	save `w'_jbpen, replace
}

use a_jbpen, clear
foreach w in b d f h j l {
append using `w'_jbpen
}

mvdecode jbpen, mv(-10/-1)

// Create an indicator variable for category 1
gen category1_jbpen = (jbpen == 1)

// Collapse the data
collapse (count) total_jbpen=jbpen (sum) category1_jbpen, by(wave)

// Calculate the percentage of category 1
gen percent_category1 = (category1_jbpen / total_jbpen) * 100


levelsof wave, local(wave_levels)
twoway (line percent_category1 wave, lcolor(blue) lwidth(medium)) (scatter percent_category1 wave, mcolor(red) msymbol(O) ) ///
    , title("Employer runs a pension scheme by wave") ///
    xtitle("Wave") ///
    ytitle("Employer runs a pension scheme - yes") ///
    xlabel(`wave_levels', valuelabel) ///
    legend(off)


