global pathdata2 ""  
use pidp *jbpen using "$pathdata2/a_indresp", clear
cd ""

foreach w in a b d f h j l {
	use pidp *jbpen *age_dv *ethn_dv *jbhas *indin*_xw `w'_jbsemp using "$pathdata2/`w'_indresp", clear
	gen wave=strpos("abcdefghijklm","`w'")
	renpfix `w'_
	save `w'_jbpen, replace
}

use a_jbpen, clear
foreach w in b d f h j l {
append using `w'_jbpen
}

//creating weight for the long file
gen weight = .
replace weight = indinus_xw if inrange(wave,1,1)
replace weight = indinub_xw if inrange(wave,2,6)
replace weight = indinui_xw if inrange(wave,8,12)

recode ethn_dv (1=0 "White") (2/4=1 "Otherwhite") (9=2 "Indian") (10=3 "Pakistani") (11=4 "Bangladeshi") (12=5 "Chinese") (14/16=6 "Black") (5/8=7 "Mixed") (else =8 "Arabs&otherAsian"),gen (ethnic)

save jbpen, replace


use jbpen, clear
mvdecode _all, mv(-10/-1)

// Create indicators variable for yes jbpen

gen yes_jbpen = (jbpen == 1)
gen yes_jbpen_w = yes_jbpen * weight

//creating total for non-missing jbpen
gen jbpennotm=jbpen
replace jbpennotm=1 if jbpen==2
gen jbpennotm_w=jbpennotm*weight

save jbpentables, replace
//overall
use jbpentables, clear

//user's conditions
keep if age_dv>=45 & age_dv<=64
keep if jbhas==1
keep if jbsemp==1


collapse (sum) total_jbpen_w=jbpennotm_w total_jbpen=jbpennotm yes_jbpen yes_jbpen_w, by(wave)

// Calculate the percentage of yes jbpen
gen percent_yes = (yes_jbpen / total_jbpen) * 100
gen percent_yes_w = (yes_jbpen_w / total_jbpen_w) * 100

//unweighted graph
levelsof wave, local(wave_levels)
twoway (line percent_yes wave, lcolor(blue) lwidth(medium)) (scatter percent_yes wave, mcolor(red) msymbol(O) ) ///
    , title("Employer runs a pension scheme by wave") ///
    xtitle("Wave") ///
    ytitle("Employer runs a pension scheme - yes") ///
    xlabel(`wave_levels', valuelabel) ///
    legend(off) ///
    note("Note: sample limited to if age_dv>=45 & age_dv<=64  & jbhas==1 & jbsemp==1, unweighted")
	
//weighted graph
levelsof wave, local(wave_levels)
twoway (line percent_yes_w wave, lcolor(blue) lwidth(medium)) (scatter percent_yes_w wave, mcolor(red) msymbol(O) ) ///
    , title("Employer runs a pension scheme by wave") ///
    xtitle("Wave") ///
    ytitle("Employer runs a pension scheme - yes") ///
    xlabel(`wave_levels', valuelabel) ///
    legend(off) ///
    note("Note: sample limited to if age_dv>=45 & age_dv<=64  & jbhas==1 & jbsemp==1, weighted by _xw weights")


/////by ethnicity	

use jbpentables, clear
fre jbpen
//keep if jbpen!=.
keep if age_dv>=45 & age_dv<=64
keep if jbhas==1
keep if jbsemp==1
collapse (sum) total_jbpen=jbpennotm total_jbpen_w=jbpennotm_w  yes_jbpen yes_jbpen_w  , by(wave ethnic)

// Calculate the percentage of yes jbpen
gen percent_yes = (yes_jbpen / total_jbpen) * 100
gen percent_yes_w = (yes_jbpen_w / total_jbpen_w) * 100

///unweighted graph

///unweighted
levelsof wave, local(wave_levels)
twoway ///
    (line percent_yes wave if ethnic == 0, lcolor(blue) lwidth(medium) lpattern(solid)) ///
    (scatter percent_yes wave if ethnic == 0, mcolor(blue) msymbol(O)) ///
    (line percent_yes wave if ethnic == 1, lcolor(red) lwidth(medium) lpattern(dash)) ///
    (scatter percent_yes wave if ethnic == 1, mcolor(red) msymbol(D)) ///
    (line percent_yes wave if ethnic == 2, lcolor(green) lwidth(medium) lpattern(dot)) ///
    (scatter percent_yes wave if ethnic == 2, mcolor(green) msymbol(T)) ///
    (line percent_yes wave if ethnic == 3, lcolor(orange) lwidth(medium) lpattern(longdash)) ///
    (scatter percent_yes wave if ethnic == 3, mcolor(orange) msymbol(X)) ///
    (line percent_yes wave if ethnic == 4, lcolor(purple) lwidth(medium) lpattern(dashdot)) ///
    (scatter percent_yes wave if ethnic == 4, mcolor(purple) msymbol(S)) ///
    (line percent_yes wave if ethnic == 5, lcolor(brown) lwidth(medium) lpattern(shortdash)) ///
    (scatter percent_yes wave if ethnic == 5, mcolor(brown) msymbol(D)) ///
    (line percent_yes wave if ethnic == 6, lcolor(cyan) lwidth(medium) lpattern(dot)) ///
    (scatter percent_yes wave if ethnic == 6, mcolor(cyan) msymbol(T)) ///
    (line percent_yes wave if ethnic == 7, lcolor(pink) lwidth(medium) lpattern(longdash)) ///
    (scatter percent_yes wave if ethnic == 7, mcolor(pink) msymbol(X)) ///
    (line percent_yes wave if ethnic == 8, lcolor(gold) lwidth(medium) lpattern(dashdotdot)) ///
    (scatter percent_yes wave if ethnic == 8, mcolor(gold) msymbol(V)) ///
    , title("Employer runs a pension scheme by wave and ethnicity") ///
    xtitle("Wave") ///
    ytitle("Employer runs a pension scheme - yes") ///
    xlabel(`wave_levels', valuelabel) ///
    legend(order(1 "White" 3 "Otherwhite" 5 "Indian" 7 "Pakistani" 9 "Bangladeshi" 11 "Chinese" 13 "Black" 15 "Mixed" 17 "Arabs&otherAsian")) /// 
	note("Note: sample limited to if age_dv>=45 & age_dv<=64  & jbhas==1 & jbsemp==1, unweighted")

///weighted graph
levelsof wave, local(wave_levels)
twoway ///
    (line percent_yes_w wave if ethnic == 0, lcolor(blue) lwidth(medium) lpattern(solid)) ///
    (scatter percent_yes_w wave if ethnic == 0, mcolor(blue) msymbol(O)) ///
    (line percent_yes_w wave if ethnic == 1, lcolor(red) lwidth(medium) lpattern(dash)) ///
    (scatter percent_yes_w wave if ethnic == 1, mcolor(red) msymbol(D)) ///
    (line percent_yes_w wave if ethnic == 2, lcolor(green) lwidth(medium) lpattern(dot)) ///
    (scatter percent_yes_w wave if ethnic == 2, mcolor(green) msymbol(T)) ///
    (line percent_yes_w wave if ethnic == 3, lcolor(orange) lwidth(medium) lpattern(longdash)) ///
    (scatter percent_yes_w wave if ethnic == 3, mcolor(orange) msymbol(X)) ///
    (line percent_yes_w wave if ethnic == 4, lcolor(purple) lwidth(medium) lpattern(dashdot)) ///
    (scatter percent_yes_w wave if ethnic == 4, mcolor(purple) msymbol(S)) ///
    (line percent_yes_w wave if ethnic == 5, lcolor(brown) lwidth(medium) lpattern(shortdash)) ///
    (scatter percent_yes_w wave if ethnic == 5, mcolor(brown) msymbol(D)) ///
    (line percent_yes_w wave if ethnic == 6, lcolor(cyan) lwidth(medium) lpattern(dot)) ///
    (scatter percent_yes_w wave if ethnic == 6, mcolor(cyan) msymbol(T)) ///
    (line percent_yes_w wave if ethnic == 7, lcolor(pink) lwidth(medium) lpattern(longdash)) ///
    (scatter percent_yes_w wave if ethnic == 7, mcolor(pink) msymbol(X)) ///
    (line percent_yes_w wave if ethnic == 8, lcolor(gold) lwidth(medium) lpattern(dashdotdot)) ///
    (scatter percent_yes_w wave if ethnic == 8, mcolor(gold) msymbol(V)) ///
    , title("Employer runs a pension scheme by wave") ///
    xtitle("Wave") ///
    ytitle("Employer runs a pension scheme - yes") ///
    xlabel(`wave_levels', valuelabel) ///
    legend(order(1 "White" 3 "Otherwhite" 5 "Indian" 7 "Pakistani" 9 "Bangladeshi" 11 "Chinese" 13 "Black" 15 "Mixed" 17 "Arabs&otherAsian"))



