clear all

global path "[data path for wave A]"

//Open data
u "${path}//a_indresp", clear
merge m:1 a_hidp using "${path}//a_hhresp", nogen keepusing(a_tenure_dv)
ren a_* *

//Keep only lone mothers
drop if depchl_dv == 1
bys hidp buno: g numads = _N
keep if numads == 1 
keep if sex == 2 
keep if ndepchl_dv > 0

//Generate descriptive variables
g homeowner = inlist(tenure_dv,1,2)
g scendfeend = max(scend,feend)
recode scendfeend (-9 = -1) (-8 = 0) (-1 = -1) (0 / 15 = 1) (16 = 2) (17 / 18 = 3) (19 / 95 = 4), generate(agelefted)
assert inrange(agelefted,-1,4)
lab def agelefted -1 "Missing" 0 "Still in edu." 1 "15 or earlier" 2 "16" 3 "17-18" 4 "19 or later" 
lab val agelefted agelefted

//Show results
tab agelefted [iw = indpxus_xw]
tab homeowner [iw = indpxus_xw]
