clear

global path "[data path for 2009-10 data]"

//Open data
u "${path}//child", clear
g numch = 1
collapse (sum) numch, by(sernum benunit)
tempfile kids
save `kids'

u "${path}//adult", clear
merge m:1 sernum using "${path}//househol", nogen keepusing(tenure)
merge m:1 sernum benunit using `kids', nogen keepusing(numch)
replace numch = 0 if numch == .

//Keep only lone mothers
bys sernum benunit: g numads = _N
keep if numads == 1 
keep if sex == 2 
keep if numch > 0

//Generate descriptive variables
g homeowner = inlist(tenure,1,2,3)
recode tea (0 / 15 = 1) (16 = 2) (17 / 18 = 3) (19 / 95 = 4), generate(agelefted)
replace agelefted = 0 if tea9697 == 96
replace agelefted = 1 if tea9697 == 97
replace agelefted = -1 if (tea == -999) & (tea9697 == -999)
assert inrange(agelefted,-1,4)
lab def agelefted -1 "Missing" 0 "Still in edu." 1 "15 or earlier" 2 "16" 3 "17-18" 4 "19 or later"
lab val agelefted agelefted

//Show results
tab agelefted [fw = gross3]
tab homeowner [fw = gross3]