*****************************************************************************************
//It creates a data file of respondents (of any age) with information about their co-resident parents matched to them
*****************************************************************************************
version 15.1
clear all
set more off
cap log close
cd "D:\Mario files\box\PhD Health Research\Effects of parental unemployment on children health\Data Analysis"
log using example2.log, replace

global main_data "D:\Mario files\box\PhD Health Research\Effects of parental unemployment on children health\Datasets\Understanding Societies (UKHLS)\UKDA-6614-stata\stata\stata13_se"
global dataout "D:\Mario files\box\PhD Health Research\Effects of parental unemployment on children health\Data Analysis"
global results "D:\Mario files\box\PhD Health Research\Effects of parental unemployment on children health\(Preliminary) Results"
global graphs ""
global tables ""


global W "a b c d e f g h i j k l m n o p q r"                                   // List af all waves
global N " 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18"
global nW : word count $W                                                       // Number of elements in the list above (In our case, number of waves)
 
set scheme s1mono                                                               // Scheme for graphs (black and white graphs)!!
clear all
capture log close   

***************************
local tm "mother"
local tf "father"


foreach w in $W {
	local i=strpos("abcdefghijklmnopqr","`w'")
	
	// Step 3: This syntax matches information of all types of parents (biological, adopted, step) 
	// If you want to only match information of biological parents then use 
	// the variables `w'_`k'npid instead of `w'_`k'nspid
	local idvar npid_bh
	
	// Step 4: Choose the data file from where you want to add parental variables 
	local file indrespSmall 

	// Step 5: Currently only 2 parental variables are being added: age_dv & employ
	// Add other variables variables you want to add from the file mentioned in Step 4
	local vars age jbhas jbstat 
	
	foreach k in m f {
		use "$dataout\parentPanelSmall`i'", clear
		drop if `k'`idvar'<0
		keep `k'`idvar' pidp
		rename pidp kpidp
		rename `k'`idvar' pidp
		
		
		
		merge m:1 pidp using "$dataout\indrespSmall`i'", nogen keep(3) keepus(`vars' wave)
		foreach var of local vars {
			rename `var' `var'_`k'
			local l`var': var label `var'
			lab var `var' `"`t`k'': `l`var''"'		
		}
		
		
		drop pidp
		rename kpidp pidp
		
		
		merge m:1 pidp using "$dataout\indallSmall`i'", nogen
		
		keep pidp *_`k' `k'`idvar' wave
		
		// check1
		
		save `k', replace
	}
	
	
	use m, clear
	merge m:m pidp using f
	// check
	assert _merge==3
	drop _merge
	
	order pidp, first
	order m f, last
	
	// check2
	foreach k in m f {
	foreach var of local vlist {
	assert (`w'_`var'_m==. & `w'_m`idvar'==-8) | ///
	       (`w'_`var'_m<.  & `w'_m`idvar'>-8)
	}
	}
	
	save file_`i', replace
	su 
	d		
}	


use "$dataout\file_1", clear                                             // I append all these small datasets
forvalues n=2/$nW {
append using "$dataout\file_`n'"
}

// clean up temporary files
erase m.dta
erase f.dta	
erase "$dataout\indrespPanelSmallVar`i'"
erase "$dataout\egoaltPanelSmallVarID`i'"
		