// What does this syntax file do?
// It creates a data file of respondents (of any age) with information 
// about their co-resident parents matched to them
// The output files are named file_a, file_b,... 

// Step 1: Replace "datapath" with the filepath where
// you have saved the data folders ukhls_w1, ukhls_w2....

global data "datapath"

local tm "mother"
local tf "father"

// Step 2: The syntax just does this exercise for Wave a
// Add other waves that you need
foreach w in a { 

	local i=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
	
	// Step 3: This syntax matches information of all types of parents (biological, adopted, step) 
	// If you want to only match information of biological parents then use 
	// the variables `w'_`k'npid instead of `w'_`k'nspid
	local idvar nspid
	
	// Step 4: Choose the data file from where you want to add parental variables 
	local file indall

	// Step 5: Currently only 2 parental variables are being added: age_dv & employ
	// Add other variables variables you want to add from the file mentioned in Step 4
	local vars `w'_age_dv `w'_employ
		
	foreach k in m f {
		use "$data/ukhls_w`i'/`w'_indall", clear
		drop if `w'_`k'`idvar'<0
		keep `w'_`k'`idvar' pidp
		rename pidp kpidp
		rename `w'_`k'`idvar' pidp
		
		merge m:1 pidp using "$data/ukhls_w`i'/`w'_`file'", nogen keep(3) ///
		keepus(`vars') 

		foreach var of local vars {
			rename `var' `var'_`k'
			local l`var': var label `var'
			lab var `var' `"`t`k'': `l`var''"'		
		}
		drop pidp
		rename kpidp pidp
		merge 1:1 pidp using "$data/ukhls_w`i'/`w'_indall", nogen
		
		keep pidp *_`k' `w'_`k'`idvar'
		
		// check1
		isid pidp
		save `k', replace
	}
	use m, clear
	merge 1:1 pidp using f
	// check
	assert _merge==3
	drop _merge
	
	order pidp, first
	order *_m *_f, last
	
	// check2
	foreach k in m f {
	foreach var of local vlist {
	assert (`w'_`var'_m==. & `w'_m`idvar'==-8) | ///
	       (`w'_`var'_m<.  & `w'_m`idvar'>-8)
	}
	}
	
	save file_`w', replace
	su 
	d
}



// clean up temporary files
erase m.dta
erase f.dta	
		
