// What does this syntax file do?
// It creates a data file of respondents (of any age) with information 
// about their co-resident (at that wave) parents matched to them
// The output files are named file_a, file_b,... for each wave a, b,...
// This files include only those sample members who are living with at least
// one parent in that wave.

// Step 1: Replace "datapath" with the filepath where
// you have saved the data folders ukhls_w1, ukhls_w2....
global data "datapath"

local tm "mother"
local tf "father"

// Step 2: The syntax just does this exercise for Wave a
// Add other waves that you need
foreach w in a { 

	local i=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
	
	// Step 3: This syntax matches information of all types of parents //
	// (biological, adopted, step). If you want to only match information of 
	// biological parents then replace "nspid" with "npid" below
	local idvar nspid
	
	// Step 4: Choose the data file from where you want to add parental variables 
	// Here the datafile used for parental info is INDALL
	local file indall

	// Step 5: Currently only 2 parental variables are being added: age_dv & employ
	// Add other variables variables you want to add from the file that you 
	// have mentioned in Step 4
	local vars `w'_age_dv `w'_employ
	
	// This loop repeats the process first for the mother then the father.
	foreach k in m f {
		// Open INDALL file
		use "$datapath/ukhls_w`i'/`w'_indall", clear
		// Drop cases with no parent id (so parent not in household in this wave)
		drop if `w'_`k'`idvar'<0
		keep `w'_`k'`idvar' pidp
		// rename pidp to kpidp (kid's pidp)
		rename pidp kpidp
		// rename parents' pidp to pidp to be able to match their information in files where they are identified by pidp
		rename `w'_`k'`idvar' pidp
		// merge parents' information using their pidp and only keep cases
		// that are in both files and keep the variables mentioned in the list "local vars"
		merge m:1 pidp using "$datapath/ukhls_w`i'/`w'_`file'", nogen keep(3) ///
		keepus(`vars') 
		// rename parents' variables to names that will have a suffix _m/_f to show that these are of the mother/father
		foreach var of local vars {
			rename `var' `var'_`k'
			local l`var': var label `var'
			lab var `var' `"`t`k'': `l`var''"'		
		}
		// drop parents' ID
		drop pidp
		// rename kid's pidp back to pidp
		rename kpidp pidp
		// keep just the kid's pidp and their parents' information
		keep pidp *_`k' 
		
		// check1 - to make sure each row is uniquely identified by pidp as the original file
		isid pidp
		save `k', replace
	}
	// Now merge mother and father information
	use m, clear
	merge 1:1 pidp using f
	drop _merge
	
	order pidp, first
	order *_m *_f, last
	
	save file_`w', replace
	su 
	d
}



// clean up temporary files
erase m.dta
erase f.dta	
		

